;*****************************************************************************/
; FUNCTION     : cfg_ROMCPY                                                  */
; PURPOSE      : This function copies initialized data from Flash to SRAM    */
;                 for the ".data" and ".sdata" sections.                     */
;                                                                            */
; INPUT NOTES  : __DATA_ROM -- defined by the linker EABI                    */
;                __ROM_COPY_SIZE -- Flash area size, in bytes, to be copied  */
;                                     into SRAM.                             */
;                __SRAM_COPY_START -- Start of ".data" section               */
; 									     */	
; RETURN NOTES : None                                                        */
; WARNING      : Registers used: R10 -- to set .data or .sdata ROM pointer   */
;                                R9 -- to hold remaining ROM_COPY_SIZE bytes */
;                                R5 -- to set SRAM pointer                   */
;                                R4 -- hold the copy data                    */
;                                                                            */
;*****************************************************************************/

   .global cfg_ROMCOPY

   .extern __ROM_COPY_SIZE  	    	; All .externs are defined in the linker file
   .extern __SRAM_COPY_START 

   .equ __COPY_OFFSET, 1     
  
.section .text  

cfg_ROMCOPY:

; Set GPR9 to the count of the SRAM load size
    lis    r9, __ROM_COPY_SIZE@ha   	; Load upper SRAM load size (; of bytes) into R9
    addic. r9,r9, __ROM_COPY_SIZE@l 	; Load lower SRAM load size into R9
                                    	;  The "." sets the condition flag

    beq ROMCPYEND                   	; Exit cfg_ROMCPY if size is zero

    mtctr  r9                       	; Store # of bytes to be moved in spr CTR

    lis   r10, __DATA_ROM@ha        	; Load address of first SRAM load into R10
    addi  r10,r10, __DATA_ROM@l     	; Load lower address of SRAM load into R10
    subi  r10,r10, __COPY_OFFSET       	; Decrement address to prepare for ROMCPYLOOP    

; Load SRAM base address (__SRAM_COPY_START) for loading instructions into R5
    lis   r5, __SRAM_COPY_START@h      	; Load upper SRAM address into R5
    ori   r5, r5, __SRAM_COPY_START@l  	; Load lower SRAM address into R5
    subi  r5, r5, __COPY_OFFSET         ; Decrement address to prepare for ROMCPYLOOP

ROMCPYLOOP:
    lbzu   r4, __COPY_OFFSET(r10) 	; Load data byte at R10 into R4,incrementing (update) ROM address
    stbu   r4, __COPY_OFFSET(r5)  	; Store R4 data byte into SRAM at R5 and update SRAM address 
    bdnz   ROMCPYLOOP          		; Branch if more bytes to load from ROM

ROMCPYEND: 
    blr
; End of cfg_ROMCPY
